#include <iostream>
#include <map>
#include <vector>
#include <algorithm>
#include <iomanip>

double calc(std::vector<std::pair<int, double>> v, int b, double prec) {
	double sum = 0;
	for (int i = b; i < v.size(); ++i) {
		sum += v[i].first;
	}
	sum *= (prec / 100.0);
	return sum;
}

int main()
{
	std::vector<std::pair<int, double>> v;
	double last = 0, current;
	int N; std::cin >> N;
	for (int i = 0; i < N; ++i) {
		std::pair<int, double> t;
		std::cin >> t.first >> t.second;
		v.push_back(t);
	}
	std::sort(v.begin(), v.end(), [](std::pair<int, double> f, std::pair<int, double> s) {return f.second < s.second; });
	for (int i = 0; i < N; ++i) {
		current = calc(v, i, v[i].second);
		if (current < last) {
			break;
		}
		last = current;
	}
	std::cout << std::setprecision(4) << std::fixed << last;
}